/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_fi extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_bax = "bamum";
        final String metaValue_doi = "dogri";
        final String metaValue_kpe = "kpelle";
        final String metaValue_mak = "makassar";
        final String metaValue_men = "mende";
        final String metaValue_nqo = "n\u2019ko";
        final Object[][] data = new Object[][] {
            { "001", "maailma" },
            { "002", "Afrikka" },
            { "003", "Pohjois-Amerikka" },
            { "005", "Etel\u00e4-Amerikka" },
            { "009", "Oseania" },
            { "011", "L\u00e4nsi-Afrikka" },
            { "013", "V\u00e4li-Amerikka" },
            { "014", "It\u00e4-Afrikka" },
            { "015", "Pohjois-Afrikka" },
            { "017", "Keski-Afrikka" },
            { "018", "etel\u00e4inen Afrikka" },
            { "019", "Amerikka" },
            { "021", "pohjoinen Amerikka" },
            { "029", "Karibia" },
            { "030", "It\u00e4-Aasia" },
            { "034", "Etel\u00e4-Aasia" },
            { "035", "Kaakkois-Aasia" },
            { "039", "Etel\u00e4-Eurooppa" },
            { "053", "Australaasia" },
            { "054", "Melanesia" },
            { "057", "Mikronesian alue" },
            { "061", "Polynesia" },
            { "142", "Aasia" },
            { "143", "Keski-Aasia" },
            { "145", "L\u00e4nsi-Aasia" },
            { "150", "Eurooppa" },
            { "151", "It\u00e4-Eurooppa" },
            { "154", "Pohjois-Eurooppa" },
            { "155", "L\u00e4nsi-Eurooppa" },
            { "202", "Saharan etel\u00e4puolinen Afrikka" },
            { "419", "Latinalainen Amerikka" },
            { "AC", "Ascension-saari" },
            { "AD", "Andorra" },
            { "AE", "Arabiemiirikunnat" },
            { "AF", "Afganistan" },
            { "AG", "Antigua ja Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antarktis" },
            { "AR", "Argentiina" },
            { "AS", "Amerikan Samoa" },
            { "AT", "It\u00e4valta" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "Ahvenanmaa" },
            { "AZ", "Azerbaid\u017ean" },
            { "BA", "Bosnia ja Hertsegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgia" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint-Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Karibian Alankomaat" },
            { "BR", "Brasilia" },
            { "BS", "Bahama" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet\u2019nsaari" },
            { "BW", "Botswana" },
            { "BY", "Valko-Ven\u00e4j\u00e4" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Kookossaaret (Keelingsaaret)" },
            { "CD", "Kongon demokraattinen tasavalta" },
            { "CF", "Keski-Afrikan tasavalta" },
            { "CG", "Kongon tasavalta" },
            { "CH", "Sveitsi" },
            { "CI", "Norsunluurannikko" },
            { "CK", "Cookinsaaret" },
            { "CL", "Chile" },
            { "CM", "Kamerun" },
            { "CN", "Kiina" },
            { "CO", "Kolumbia" },
            { "CP", "Clippertoninsaari" },
            { "CR", "Costa Rica" },
            { "CU", "Kuuba" },
            { "CV", "Kap Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Joulusaari" },
            { "CY", "Kypros" },
            { "CZ", "T\u0161ekki" },
            { "DE", "Saksa" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Tanska" },
            { "DM", "Dominica" },
            { "DO", "Dominikaaninen tasavalta" },
            { "DZ", "Algeria" },
            { "EA", "Ceuta ja Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Viro" },
            { "EG", "Egypti" },
            { "EH", "L\u00e4nsi-Sahara" },
            { "ER", "Eritrea" },
            { "ES", "Espanja" },
            { "ET", "Etiopia" },
            { "EU", "Euroopan unioni" },
            { "EZ", "euroalue" },
            { "FI", "Suomi" },
            { "FJ", "Fid\u017ei" },
            { "FK", "Falklandinsaaret" },
            { "FM", "Mikronesia" },
            { "FO", "F\u00e4rsaaret" },
            { "FR", "Ranska" },
            { "GA", "Gabon" },
            { "GB", "Iso-Britannia" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "Ranskan Guayana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Gr\u00f6nlanti" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "P\u00e4iv\u00e4ntasaajan Guinea" },
            { "GR", "Kreikka" },
            { "GS", "Etel\u00e4-Georgia ja Etel\u00e4iset Sandwichinsaaret" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Hongkong \u2013 Kiinan erityishallintoalue" },
            { "HM", "Heard ja McDonaldinsaaret" },
            { "HN", "Honduras" },
            { "HR", "Kroatia" },
            { "HT", "Haiti" },
            { "HU", "Unkari" },
            { "IC", "Kanariansaaret" },
            { "ID", "Indonesia" },
            { "IE", "Irlanti" },
            { "IL", "Israel" },
            { "IM", "Mansaari" },
            { "IN", "Intia" },
            { "IO", "Brittil\u00e4inen Intian valtameren alue" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Islanti" },
            { "IT", "Italia" },
            { "JE", "Jersey" },
            { "JM", "Jamaika" },
            { "JO", "Jordania" },
            { "JP", "Japani" },
            { "KE", "Kenia" },
            { "KG", "Kirgisia" },
            { "KH", "Kambod\u017ea" },
            { "KI", "Kiribati" },
            { "KM", "Komorit" },
            { "KN", "Saint Kitts ja Nevis" },
            { "KP", "Pohjois-Korea" },
            { "KR", "Etel\u00e4-Korea" },
            { "KW", "Kuwait" },
            { "KY", "Caymansaaret" },
            { "KZ", "Kazakstan" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "Saint Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Liettua" },
            { "LU", "Luxemburg" },
            { "LV", "Latvia" },
            { "LY", "Libya" },
            { "MA", "Marokko" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "Saint-Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Marshallinsaaret" },
            { "MK", "Pohjois-Makedonia" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongolia" },
            { "MO", "Macao \u2013 Kiinan erityishallintoalue" },
            { "MP", "Pohjois-Mariaanit" },
            { "MQ", "Martinique" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Malediivit" },
            { "MW", "Malawi" },
            { "MX", "Meksiko" },
            { "MY", "Malesia" },
            { "MZ", "Mosambik" },
            { "NA", "Namibia" },
            { "NC", "Uusi-Kaledonia" },
            { "NE", "Niger" },
            { "NF", "Norfolkinsaari" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Alankomaat" },
            { "NO", "Norja" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Uusi-Seelanti" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Ranskan Polynesia" },
            { "PG", "Papua-Uusi-Guinea" },
            { "PH", "Filippiinit" },
            { "PK", "Pakistan" },
            { "PL", "Puola" },
            { "PM", "Saint-Pierre ja Miquelon" },
            { "PN", "Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestiinalaisalue" },
            { "PT", "Portugali" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "Oseanian erillissaaret" },
            { "RE", "R\u00e9union" },
            { "RO", "Romania" },
            { "RS", "Serbia" },
            { "RU", "Ven\u00e4j\u00e4" },
            { "RW", "Ruanda" },
            { "SA", "Saudi-Arabia" },
            { "SB", "Salomonsaaret" },
            { "SC", "Seychellit" },
            { "SD", "Sudan" },
            { "SE", "Ruotsi" },
            { "SG", "Singapore" },
            { "SH", "Saint Helena" },
            { "SI", "Slovenia" },
            { "SJ", "Svalbard ja Jan Mayen" },
            { "SK", "Slovakia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Suriname" },
            { "SS", "Etel\u00e4-Sudan" },
            { "ST", "S\u00e3o Tom\u00e9 ja Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syyria" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks- ja Caicossaaret" },
            { "TD", "T\u0161ad" },
            { "TF", "Ranskan etel\u00e4iset ja antarktiset alueet" },
            { "TG", "Togo" },
            { "TH", "Thaimaa" },
            { "TJ", "Tad\u017eikistan" },
            { "TK", "Tokelau" },
            { "TL", "It\u00e4-Timor" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "TR", "Turkki" },
            { "TT", "Trinidad ja Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tansania" },
            { "UA", "Ukraina" },
            { "UG", "Uganda" },
            { "UM", "Yhdysvaltain erillissaaret" },
            { "UN", "Yhdistyneet kansakunnat" },
            { "US", "Yhdysvallat" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbekistan" },
            { "VA", "Vatikaani" },
            { "VC", "Saint Vincent ja Grenadiinit" },
            { "VE", "Venezuela" },
            { "VG", "Brittil\u00e4iset Neitsytsaaret" },
            { "VI", "Yhdysvaltain Neitsytsaaret" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis ja Futuna" },
            { "WS", "Samoa" },
            { "XA", "pseudoaksentit" },
            { "XB", "kaksisuuntainen pseudo" },
            { "XK", "Kosovo" },
            { "YE", "Jemen" },
            { "YT", "Mayotte" },
            { "ZA", "Etel\u00e4-Afrikka" },
            { "ZM", "Sambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "tuntematon alue" },
            { "aa", "afar" },
            { "ab", "abhaasi" },
            { "ae", "avesta" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amhara" },
            { "an", "aragonia" },
            { "ar", "arabia" },
            { "as", "assami" },
            { "av", "avaari" },
            { "ay", "aimara" },
            { "az", "azeri" },
            { "ba", "ba\u0161kiiri" },
            { "be", "valkoven\u00e4j\u00e4" },
            { "bg", "bulgaria" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", "bengali" },
            { "bo", "tiibet" },
            { "br", "bretoni" },
            { "bs", "bosnia" },
            { "ca", "katalaani" },
            { "ce", "t\u0161et\u0161eeni" },
            { "ch", "t\u0161amorro" },
            { "co", "korsika" },
            { "cr", "cree" },
            { "cs", "t\u0161ekki" },
            { "cu", "kirkkoslaavi" },
            { "cv", "t\u0161uvassi" },
            { "cy", "kymri" },
            { "da", "tanska" },
            { "de", "saksa" },
            { "dv", "divehi" },
            { "dz", "dzongkha" },
            { "ee", "ewe" },
            { "el", "kreikka" },
            { "en", "englanti" },
            { "eo", "esperanto" },
            { "es", "espanja" },
            { "et", "viro" },
            { "eu", "baski" },
            { "fa", "persia" },
            { "ff", "fulani" },
            { "fi", "suomi" },
            { "fj", "fid\u017ei" },
            { "fo", "f\u00e4\u00e4ri" },
            { "fr", "ranska" },
            { "fy", "l\u00e4nsifriisi" },
            { "ga", "iiri" },
            { "gd", "gaeli" },
            { "gl", "galicia" },
            { "gn", "guarani" },
            { "gu", "gud\u017earati" },
            { "gv", "manksi" },
            { "ha", "hausa" },
            { "he", "heprea" },
            { "hi", "hindi" },
            { "ho", "hiri-motu" },
            { "hr", "kroatia" },
            { "ht", "haiti" },
            { "hu", "unkari" },
            { "hy", "armenia" },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indonesia" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "sichuanin-yi" },
            { "ik", "inupiaq" },
            { "io", "ido" },
            { "is", "islanti" },
            { "it", "italia" },
            { "iu", "inuktitut" },
            { "ja", "japani" },
            { "jv", "jaava" },
            { "ka", "georgia" },
            { "kg", "kongo" },
            { "ki", "kikuju" },
            { "kj", "kuanjama" },
            { "kk", "kazakki" },
            { "kl", "kalaallisut" },
            { "km", "khmer" },
            { "kn", "kannada" },
            { "ko", "korea" },
            { "kr", "kanuri" },
            { "ks", "ka\u0161miri" },
            { "ku", "kurdi" },
            { "kv", "komi" },
            { "kw", "korni" },
            { "ky", "kirgiisi" },
            { "la", "latina" },
            { "lb", "luxemburg" },
            { "lg", "ganda" },
            { "li", "limburg" },
            { "ln", "lingala" },
            { "lo", "lao" },
            { "lt", "liettua" },
            { "lu", "katanganluba" },
            { "lv", "latvia" },
            { "mg", "malagassi" },
            { "mh", "marshall" },
            { "mi", "maori" },
            { "mk", "makedonia" },
            { "ml", "malajalam" },
            { "mn", "mongoli" },
            { "mr", "marathi" },
            { "ms", "malaiji" },
            { "mt", "malta" },
            { "my", "burma" },
            { "na", "nauru" },
            { "nb", "norjan bokm\u00e5l" },
            { "nd", "pohjois-ndebele" },
            { "ne", "nepali" },
            { "ng", "ndonga" },
            { "nl", "hollanti" },
            { "nn", "norjan nynorsk" },
            { "no", "norja" },
            { "nr", "etel\u00e4-ndebele" },
            { "nv", "navajo" },
            { "ny", "njand\u017ea" },
            { "oc", "oksitaani" },
            { "oj", "od\u017eibwa" },
            { "om", "oromo" },
            { "or", "orija" },
            { "os", "osseetti" },
            { "pa", "pand\u017eabi" },
            { "pi", "paali" },
            { "pl", "puola" },
            { "ps", "pa\u0161tu" },
            { "pt", "portugali" },
            { "qu", "ket\u0161ua" },
            { "rm", "retoromaani" },
            { "rn", "rundi" },
            { "ro", "romania" },
            { "ru", "ven\u00e4j\u00e4" },
            { "rw", "ruanda" },
            { "sa", "sanskrit" },
            { "sc", "sardi" },
            { "sd", "sindhi" },
            { "se", "pohjoissaame" },
            { "sg", "sango" },
            { "sh", "serbokroaatti" },
            { "si", "sinhala" },
            { "sk", "slovakki" },
            { "sl", "sloveeni" },
            { "sm", "samoa" },
            { "sn", "\u0161ona" },
            { "so", "somali" },
            { "sq", "albania" },
            { "sr", "serbia" },
            { "ss", "swazi" },
            { "st", "etel\u00e4sotho" },
            { "su", "sunda" },
            { "sv", "ruotsi" },
            { "sw", "swahili" },
            { "ta", "tamili" },
            { "te", "telugu" },
            { "tg", "tad\u017eikki" },
            { "th", "thai" },
            { "ti", "tigrinja" },
            { "tk", "turkmeeni" },
            { "tl", "tagalog" },
            { "tn", "tswana" },
            { "to", "tonga" },
            { "tr", "turkki" },
            { "ts", "tsonga" },
            { "tt", "tataari" },
            { "tw", "twi" },
            { "ty", "tahiti" },
            { "ug", "uiguuri" },
            { "uk", "ukraina" },
            { "ur", "urdu" },
            { "uz", "uzbekki" },
            { "ve", "venda" },
            { "vi", "vietnam" },
            { "vo", "volap\u00fck" },
            { "wa", "valloni" },
            { "wo", "wolof" },
            { "xh", "xhosa" },
            { "yi", "jiddi\u0161" },
            { "yo", "joruba" },
            { "za", "zhuang" },
            { "zh", "kiina" },
            { "zu", "zulu" },
            { "ace", "at\u0161eh" },
            { "ach", "at\u0161oli" },
            { "ada", "adangme" },
            { "ady", "adyge" },
            { "aeb", "tunisianarabia" },
            { "afh", "afrihili" },
            { "agq", "aghem" },
            { "ain", "ainu" },
            { "akk", "akkadi" },
            { "akz", "alabama" },
            { "ale", "aleutti" },
            { "aln", "gegi" },
            { "alt", "altai" },
            { "ang", "muinaisenglanti" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "arc", "valtakunnanaramea" },
            { "arn", "mapudungun" },
            { "aro", "araona" },
            { "arp", "arapaho" },
            { "arq", "algerianarabia" },
            { "ars", "arabia \u2013 najd" },
            { "arw", "arawak" },
            { "ary", "marokonarabia" },
            { "arz", "egyptinarabia" },
            { "asa", "asu" },
            { "ase", "amerikkalainen viittomakieli" },
            { "ast", "asturia" },
            { "atj", "atikamekw" },
            { "avk", "kotava" },
            { "awa", "awadhi" },
            { "bal", "belut\u0161i" },
            { "ban", "bali" },
            { "bar", "baijeri" },
            { "bas", "basaa" },
            { "bax", metaValue_bax },
            { "bbc", "batak-toba" },
            { "bbj", "ghomala" },
            { "bej", "bed\u017ea" },
            { "bem", "bemba" },
            { "bew", "betawi" },
            { "bez", "bena" },
            { "bfd", "fut" },
            { "bfq", "badaga" },
            { "bgn", "l\u00e4nsibelut\u0161i" },
            { "bho", "bhod\u017epuri" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "bjn", "banjar" },
            { "bkm", "kom" },
            { "bla", "siksika" },
            { "bpy", "bi\u0161nupria" },
            { "bqi", "bahtiari" },
            { "bra", "brad\u017e" },
            { "brh", "brahui" },
            { "brx", "bodo" },
            { "bss", "koose" },
            { "bua", "burjaatti" },
            { "bug", "bugi" },
            { "bum", "bulu" },
            { "byn", "bilin" },
            { "byv", "medumba" },
            { "cad", "caddo" },
            { "car", "karibi" },
            { "cay", "cayuga" },
            { "cch", "atsam" },
            { "ccp", "chakma" },
            { "ceb", "cebuano" },
            { "cgg", "kiga" },
            { "chb", "t\u0161ibt\u0161a" },
            { "chg", "t\u0161agatai" },
            { "chk", "chuuk" },
            { "chm", "mari" },
            { "chn", "chinook-jargon" },
            { "cho", "choctaw" },
            { "chp", "chipewyan" },
            { "chr", "cherokee" },
            { "chy", "cheyenne" },
            { "ckb", "soran\u00ee" },
            { "clc", "chilcotin" },
            { "cop", "kopti" },
            { "cps", "capiznon" },
            { "crg", "michif" },
            { "crh", "krimintataari" },
            { "crj", "east cree (etel\u00e4inen)" },
            { "crk", "plains cree" },
            { "crl", "east cree (pohjoinen)" },
            { "crm", "moose cree" },
            { "crr", "pamlico" },
            { "crs", "seychellienkreoli" },
            { "csb", "ka\u0161ubi" },
            { "csw", "swampy cree" },
            { "dak", "dakota" },
            { "dar", "dargi" },
            { "dav", "taita" },
            { "del", "delaware" },
            { "den", "slevi" },
            { "dgr", "dogrib" },
            { "din", "dinka" },
            { "dje", "djerma" },
            { "doi", metaValue_doi },
            { "dsb", "alasorbi" },
            { "dtp", "dusun" },
            { "dua", "duala" },
            { "dum", "keskihollanti" },
            { "dyo", "jola-fonyi" },
            { "dyu", "djula" },
            { "dzg", "dazaga" },
            { "ebu", "embu" },
            { "efi", "efik" },
            { "egl", "emilia" },
            { "egy", "muinaisegypti" },
            { "eka", "ekajuk" },
            { "elx", "elami" },
            { "enm", "keskienglanti" },
            { "esu", "alaskanjupik" },
            { "ewo", "ewondo" },
            { "ext", "extremadura" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "fil", "filipino" },
            { "fit", "me\u00e4nkieli" },
            { "fon", "fon" },
            { "frc", "cajunranska" },
            { "frm", "keskiranska" },
            { "fro", "muinaisranska" },
            { "frp", "arpitaani" },
            { "frr", "pohjoisfriisi" },
            { "frs", "it\u00e4friisi" },
            { "fur", "friuli" },
            { "gaa", "ga" },
            { "gag", "gagauzi" },
            { "gan", "gan-kiina" },
            { "gay", "gajo" },
            { "gba", "gbaja" },
            { "gbz", "zoroastrialaisdari" },
            { "gez", "ge\u2019ez" },
            { "gil", "kiribati" },
            { "glk", "gilaki" },
            { "gmh", "keskiyl\u00e4saksa" },
            { "goh", "muinaisyl\u00e4saksa" },
            { "gom", "goankonkani" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", "gootti" },
            { "grb", "grebo" },
            { "grc", "muinaiskreikka" },
            { "gsw", "sveitsinsaksa" },
            { "guc", "wayuu" },
            { "gur", "frafra" },
            { "guz", "gusii" },
            { "gwi", "gwit\u0161in" },
            { "hai", "haida" },
            { "hak", "hakka-kiina" },
            { "haw", "havaiji" },
            { "hax", "haida (etel\u00e4inen)" },
            { "hif", "fid\u017einhindi" },
            { "hil", "hiligaino" },
            { "hit", "heetti" },
            { "hmn", "hmong" },
            { "hsb", "yl\u00e4sorbi" },
            { "hsn", "xiang-kiina" },
            { "hup", "hupa" },
            { "hur", "halkomelem" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ikt", "L\u00e4nsi-Kanadan inuktitut" },
            { "ilo", "iloko" },
            { "inh", "inguu\u0161i" },
            { "izh", "inkeroinen" },
            { "jam", "jamaikankreolienglanti" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "machame" },
            { "jpr", "juutalaispersia" },
            { "jrb", "juutalaisarabia" },
            { "jut", "juutti" },
            { "kaa", "karakalpakki" },
            { "kab", "kabyyli" },
            { "kac", "kat\u0161in" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kaw", "kavi" },
            { "kbd", "kabardi" },
            { "kbl", "kanembu" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "kapverdenkreoli" },
            { "ken", "kenyang" },
            { "kfo", "norsunluurannikonkoro" },
            { "kgp", "kaingang" },
            { "kha", "khasi" },
            { "kho", "khotani" },
            { "khq", "koyra chiini" },
            { "khw", "khowar" },
            { "kiu", "kirmanjki" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kmb", "kimbundu" },
            { "koi", "komipermjakki" },
            { "kok", "konkani" },
            { "kos", "kosrae" },
            { "kpe", metaValue_kpe },
            { "krc", "karat\u0161ai-balkaari" },
            { "kri", "krio" },
            { "krj", "kinaray-a" },
            { "krl", "karjala" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "ksf", "bafia" },
            { "ksh", "k\u00f6lsch" },
            { "kum", "kumykki" },
            { "kut", "kutenai" },
            { "kwk", "kwak\u02bcwala" },
            { "lad", "ladino" },
            { "lag", "lango" },
            { "lah", "lahnda" },
            { "lam", "lamba" },
            { "lez", "lezgi" },
            { "lfn", "lingua franca nova" },
            { "lij", "liguuri" },
            { "lil", "lillooet" },
            { "liv", "liivi" },
            { "lkt", "lakota" },
            { "lmo", "lombardi" },
            { "lol", "mongo" },
            { "lou", "louisianankreoli" },
            { "loz", "lozi" },
            { "lrc", "pohjoisluri" },
            { "lsm", "samia" },
            { "ltg", "latgalli" },
            { "lua", "luluanluba" },
            { "lui", "luise\u00f1o" },
            { "lun", "lunda" },
            { "luo", "luo" },
            { "lus", "lusai" },
            { "luy", "luhya" },
            { "lzh", "klassinen kiina" },
            { "lzz", "lazi" },
            { "mad", "madura" },
            { "maf", "mafa" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", metaValue_mak },
            { "man", "mandingo" },
            { "mas", "maasai" },
            { "mde", "maba" },
            { "mdf", "mok\u0161a" },
            { "mdr", "mandar" },
            { "men", metaValue_men },
            { "mer", "meru" },
            { "mfe", "morisyen" },
            { "mga", "keski-iiri" },
            { "mgh", "makua-meetto" },
            { "mgo", "meta\u2019" },
            { "mic", "micmac" },
            { "min", "minangkabau" },
            { "mnc", "mant\u0161u" },
            { "mni", "manipuri" },
            { "moe", "innu-aimun" },
            { "moh", "mohawk" },
            { "mos", "mossi" },
            { "mrj", "vuorimari" },
            { "mua", "mundang" },
            { "mul", "useita kieli\u00e4" },
            { "mus", "creek" },
            { "mwl", "mirandeesi" },
            { "mwr", "marwari" },
            { "mwv", "mentawai" },
            { "mye", "myene" },
            { "myv", "ers\u00e4" },
            { "mzn", "mazandarani" },
            { "nan", "min nan -kiina" },
            { "nap", "napoli" },
            { "naq", "nama" },
            { "nds", "alasaksa" },
            { "new", "newari" },
            { "nia", "nias" },
            { "niu", "niue" },
            { "njo", "ao naga" },
            { "nmg", "kwasio" },
            { "nnh", "ngiemboon" },
            { "nog", "nogai" },
            { "non", "muinaisnorja" },
            { "nov", "novial" },
            { "nqo", metaValue_nqo },
            { "nso", "pohjoissotho" },
            { "nus", "nuer" },
            { "nwc", "klassinen newari" },
            { "nym", "nyamwezi" },
            { "nyn", "nyankole" },
            { "nyo", "nyoro" },
            { "nzi", "nzima" },
            { "ojb", "luoteis-od\u017eibwa" },
            { "ojc", "keskiojibwa" },
            { "ojs", "oji-cree" },
            { "ojw", "l\u00e4nsi-od\u017eibwa" },
            { "oka", "okanagan" },
            { "osa", "osage" },
            { "ota", "osmani" },
            { "pag", "pangasinan" },
            { "pal", "pahlavi" },
            { "pam", "pampanga" },
            { "pap", "papiamentu" },
            { "pau", "palau" },
            { "pcd", "picardi" },
            { "pcm", "nigerianpidgin" },
            { "pdc", "pennsylvaniansaksa" },
            { "pdt", "plautdietsch" },
            { "peo", "muinaispersia" },
            { "pfl", "pfaltsi" },
            { "phn", "foinikia" },
            { "pis", "pijin" },
            { "pms", "piemonte" },
            { "pnt", "pontoksenkreikka" },
            { "pon", "pohnpei" },
            { "pqm", "maliseet-passamaquoddy" },
            { "prg", "muinaispreussi" },
            { "pro", "muinaisprovensaali" },
            { "quc", "k\u02bciche\u02bc" },
            { "qug", "chimborazonyl\u00e4nk\u00f6ket\u0161ua" },
            { "raj", "rad\u017eastani" },
            { "rap", "rapanui" },
            { "rar", "rarotonga" },
            { "rgn", "romagnoli" },
            { "rhg", "rohinga" },
            { "rif", "tarifit" },
            { "rof", "rombo" },
            { "rom", "romani" },
            { "rtm", "rotuma" },
            { "rue", "ruteeni" },
            { "rug", "roviana" },
            { "rup", "aromania" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "jakuutti" },
            { "sam", "samarianaramea" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "saz", "saura\u0161tri" },
            { "sba", "ngambay" },
            { "sbp", "sangu" },
            { "scn", "sisilia" },
            { "sco", "skotti" },
            { "sdc", "sassarinsardi" },
            { "sdh", "etel\u00e4kurdi" },
            { "see", "seneca" },
            { "seh", "sena" },
            { "sei", "seri" },
            { "sel", "selkuppi" },
            { "ses", "koyraboro senni" },
            { "sga", "muinaisiiri" },
            { "sgs", "samogiitti" },
            { "shi", "ta\u0161elhit" },
            { "shn", "shan" },
            { "shu", "t\u0161adinarabia" },
            { "sid", "sidamo" },
            { "slh", "lushootseed (etel\u00e4inen)" },
            { "sli", "sleesiansaksa" },
            { "sly", "selayar" },
            { "sma", "etel\u00e4saame" },
            { "smj", "luulajansaame" },
            { "smn", "inarinsaame" },
            { "sms", "koltansaame" },
            { "snk", "soninke" },
            { "sog", "sogdi" },
            { "srn", "sranan" },
            { "srr", "serer" },
            { "ssy", "saho" },
            { "stq", "saterlandinfriisi" },
            { "str", "straits-salish" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "sumeri" },
            { "swb", "komori" },
            { "syc", "muinaissyyria" },
            { "syr", "syyria" },
            { "szl", "sleesia" },
            { "tce", "etel\u00e4tutchone" },
            { "tcy", "tulu" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "ter", "tereno" },
            { "tet", "tetum" },
            { "tgx", "tagish" },
            { "tht", "tahlta" },
            { "tig", "tigre" },
            { "tiv", "tiv" },
            { "tkl", "tokelau" },
            { "tkr", "tsahuri" },
            { "tlh", "klingon" },
            { "tli", "tlingit" },
            { "tly", "tali\u0161i" },
            { "tmh", "tama\u0161ek" },
            { "tog", "malawintonga" },
            { "tok", "toki pona" },
            { "tpi", "tok-pisin" },
            { "tru", "turojo" },
            { "trv", "taroko" },
            { "tsd", "tsakonia" },
            { "tsi", "tsim\u0161i" },
            { "ttm", "pohjoinen tutchone" },
            { "ttt", "tati" },
            { "tum", "tumbuka" },
            { "tvl", "tuvalu" },
            { "twq", "tasawaq" },
            { "tyv", "tuva" },
            { "tzm", "keskiatlaksentamazight" },
            { "udm", "udmurtti" },
            { "uga", "ugarit" },
            { "umb", "mbundu" },
            { "und", "tuntematon kieli" },
            { "vai", "vai" },
            { "vec", "venetsia" },
            { "vep", "veps\u00e4" },
            { "vls", "l\u00e4nsiflaami" },
            { "vmf", "maininfrankki" },
            { "vot", "vatja" },
            { "vro", "v\u00f5ro" },
            { "vun", "vunjo" },
            { "wae", "walser" },
            { "wal", "wolaitta" },
            { "war", "waray" },
            { "was", "washo" },
            { "wbp", "warlpiri" },
            { "wuu", "wu-kiina" },
            { "xal", "kalmukki" },
            { "xmf", "mingreli" },
            { "xog", "soga" },
            { "yao", "jao" },
            { "yap", "japi" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yrl", "\u00f1eengat\u00fa" },
            { "yue", "kantoninkiina" },
            { "zap", "zapoteekki" },
            { "zbl", "blisskieli" },
            { "zea", "seelanti" },
            { "zen", "zenaga" },
            { "zgh", "vakioitu tamazight" },
            { "zun", "zuni" },
            { "zxx", "ei kielellist\u00e4 sis\u00e4lt\u00f6\u00e4" },
            { "zza", "zaza" },
            { "Adlm", "fulanin adlam-aakkosto" },
            { "Afak", "afaka" },
            { "Aghb", "kaukasianalbanialainen" },
            { "Ahom", "ahom" },
            { "Arab", "arabialainen" },
            { "Aran", "nastaliq" },
            { "Armi", "valtakunnanaramealainen" },
            { "Armn", "armenialainen" },
            { "Avst", "avestalainen" },
            { "Bali", "balilainen" },
            { "Bamu", metaValue_bax },
            { "Bass", "bassa" },
            { "Batk", "batakilainen" },
            { "Beng", "bengalilainen" },
            { "Bhks", "sanskritin bhaiksuki-aakkosto" },
            { "Blis", "bliss-symbolit" },
            { "Bopo", "bopomofo" },
            { "Brah", "brahmi" },
            { "Brai", "braille-pistekirjoitus" },
            { "Bugi", "bugilainen" },
            { "Buhd", "buhidilainen" },
            { "Cakm", "chakmalainen" },
            { "Cans", "kanadalaisten alkuper\u00e4iskansojen yhten\u00e4istetty tavukirjoitus" },
            { "Cari", "kaarialainen" },
            { "Cham", "t\u0161amilainen" },
            { "Cher", "cherokeelainen" },
            { "Chrs", "horemzi" },
            { "Cirt", "cirth" },
            { "Copt", "koptilainen" },
            { "Cpmn", "kypro-minolainen" },
            { "Cprt", "muinaiskyproslainen" },
            { "Cyrl", "kyrillinen" },
            { "Cyrs", "kyrillinen muinaiskirkkoslaavimuunnelma" },
            { "Deva", "devanagari" },
            { "Diak", "dives akuru" },
            { "Dogr", metaValue_doi },
            { "Dsrt", "deseret" },
            { "Dupl", "Duploy\u00e9n pikakirjoitus" },
            { "Egyd", "egyptil\u00e4inen demoottinen" },
            { "Egyh", "egyptil\u00e4inen hieraattinen" },
            { "Egyp", "egyptil\u00e4iset hieroglyfit" },
            { "Elba", "elbasanilainen" },
            { "Elym", "elymealainen" },
            { "Ethi", "etiopialainen" },
            { "Geok", "muinaisgeorgialainen" },
            { "Geor", "georgialainen" },
            { "Glag", "glagoliittinen" },
            { "Gong", "gondin gunjala" },
            { "Gonm", "masaram-gondi" },
            { "Goth", "goottilainen" },
            { "Gran", "grantha" },
            { "Grek", "kreikkalainen" },
            { "Gujr", "gud\u017earatilainen" },
            { "Guru", "gurmukhi" },
            { "Hanb", "kiinan han ja bopomofo" },
            { "Hang", "hangul" },
            { "Hani", "kiinalainen han" },
            { "Hano", "hanunoolainen" },
            { "Hans", "yksinkertaistettu" },
            { "Hant", "perinteinen" },
            { "Hatr", "hatralainen" },
            { "Hebr", "heprealainen" },
            { "Hira", "hiragana" },
            { "Hluw", "anatolialaiset hieroglyfit" },
            { "Hmng", "pahawh hmong" },
            { "Hmnp", "hmongin nyiakeng puachue" },
            { "Hrkt", "japanin tavumerkist\u00f6t" },
            { "Hung", "muinaisunkarilainen" },
            { "Inds", "induslainen" },
            { "Ital", "muinaisitalialainen" },
            { "Jamo", "korean hangulin jamo-elementit" },
            { "Java", "jaavalainen" },
            { "Jpan", "japanilainen" },
            { "Jurc", "d\u017eurt\u0161en" },
            { "Kali", "kayah li" },
            { "Kana", "katakana" },
            { "Khar", "kharosthi" },
            { "Khmr", "khmeril\u00e4inen" },
            { "Khoj", "khojki" },
            { "Kits", "kitaanin pieni merkist\u00f6" },
            { "Knda", "kannadalainen" },
            { "Kore", "korealainen" },
            { "Kpel", metaValue_kpe },
            { "Kthi", "kaithi" },
            { "Lana", "lanna" },
            { "Laoo", "laolainen" },
            { "Latf", "latinalainen fraktuuramuunnelma" },
            { "Latg", "latinalainen gaelimuunnelma" },
            { "Latn", "latinalainen" },
            { "Lepc", "lepchalainen" },
            { "Limb", "limbulainen" },
            { "Lina", "lineaari-A" },
            { "Linb", "lineaari-B" },
            { "Lisu", "Fraserin aakkoset" },
            { "Loma", "loma" },
            { "Lyci", "lyykialainen" },
            { "Lydi", "lyydialainen" },
            { "Mahj", "mahajanilainen" },
            { "Maka", metaValue_mak },
            { "Mand", "mandealainen" },
            { "Mani", "manikealainen" },
            { "Marc", "tiibetil\u00e4inen marchan-kirjoitus" },
            { "Maya", "maya-hieroglyfit" },
            { "Medf", "medefaidrin" },
            { "Mend", metaValue_men },
            { "Merc", "meroiittinen kursiivikirjoitus" },
            { "Mero", "meroiittinen" },
            { "Mlym", "malajalamilainen" },
            { "Modi", "modi-aakkoset" },
            { "Mong", "mongolilainen" },
            { "Moon", "moon-kohokirjoitus" },
            { "Mroo", "mro" },
            { "Mtei", "meitei" },
            { "Mult", "multanilainen" },
            { "Mymr", "burmalainen" },
            { "Nand", "nandinagari" },
            { "Narb", "muinaispohjoisarabialainen" },
            { "Nbat", "nabatealainen" },
            { "Newa", "newarin newa-tavukirjoitus" },
            { "Nkgb", "naxi geba" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "n\u00fcshu" },
            { "Ogam", "ogam" },
            { "Olck", "ol chiki" },
            { "Orkh", "orkhon" },
            { "Orya", "orijalainen" },
            { "Osge", "osagen aakkosto" },
            { "Osma", "osmanjalainen" },
            { "Ougr", "vanha uiguurilainen" },
            { "Palm", "palmyralainen" },
            { "Pauc", "zotuallai" },
            { "Perm", "muinaispermil\u00e4inen" },
            { "Phag", "phags-pa" },
            { "Phli", "piirtokirjoituspahlavilainen" },
            { "Phlp", "psalttaripahlavilainen" },
            { "Phlv", "kirjapahlavilainen" },
            { "Phnx", "foinikialainen" },
            { "Plrd", "Pollardin foneettinen" },
            { "Prti", "piirtokirjoitusparthialainen" },
            { "Qaag", "burmalainen zawgyi-toteutus" },
            { "Rjng", "rejang" },
            { "Rohg", "rohingalainen hanifi" },
            { "Roro", "rongorongo" },
            { "Runr", "riimukirjoitus" },
            { "Samr", "samarianaramealainen" },
            { "Sara", "sarati" },
            { "Sarb", "muinaisetel\u00e4arabialainen" },
            { "Saur", "saurashtra" },
            { "Sgnw", "SignWriting" },
            { "Shaw", "shaw\u2019lainen" },
            { "Shrd", "\u0161arada" },
            { "Sidd", "siddham-tavukirjoitus" },
            { "Sind", "khudabadi" },
            { "Sinh", "sinhalilainen" },
            { "Sogd", "sogdialainen" },
            { "Sogo", "muinaissogdialainen" },
            { "Sora", "sorang sompeng" },
            { "Soyo", "soyombo-kirjaimisto" },
            { "Sund", "sundalainen" },
            { "Sylo", "syloti nagri" },
            { "Syrc", "syyrialainen" },
            { "Syre", "syyrialainen estrangelo-muunnelma" },
            { "Syrj", "syyrialainen l\u00e4ntinen muunnelma" },
            { "Syrn", "syyrialainen it\u00e4inen muunnelma" },
            { "Tagb", "tagbanwalainen" },
            { "Takr", "takri" },
            { "Tale", "tailelainen" },
            { "Talu", "uusi tailuelainen" },
            { "Taml", "tamililainen" },
            { "Tang", "tangut" },
            { "Tavt", "tai viet" },
            { "Telu", "telugulainen" },
            { "Teng", "tengwar" },
            { "Tfng", "tifinagh" },
            { "Tglg", "tagalogilainen" },
            { "Thaa", "thaana" },
            { "Thai", "thailainen" },
            { "Tibt", "tiibetil\u00e4inen" },
            { "Tirh", "tirhuta" },
            { "Tnsa", "tangsa" },
            { "Toto", "toto" },
            { "Ugar", "ugaritilainen" },
            { "Vaii", "vailainen" },
            { "Visp", "n\u00e4kyv\u00e4 puhe" },
            { "Vith", "vithkuqi" },
            { "Wara", "varang kshiti" },
            { "Wcho", "wancholainen" },
            { "Wole", "woleai" },
            { "Xpeo", "muinaispersialainen" },
            { "Xsux", "sumerilais-akkadilainen nuolenp\u00e4\u00e4kirjoitus" },
            { "Yezi", "jesidi" },
            { "Yiii", "yil\u00e4inen" },
            { "Zanb", "zanabazar-neli\u00f6kirjaimisto" },
            { "Zinh", "peritty" },
            { "Zmth", "matemaattinen" },
            { "Zsye", "emoji-symbolit" },
            { "Zsym", "symbolit" },
            { "Zxxx", "kirjoittamaton" },
            { "Zyyy", "m\u00e4\u00e4ritt\u00e4m\u00e4t\u00f6n" },
            { "Zzzz", "tuntematon kirjoitusj\u00e4rjestelm\u00e4" },
            { "de_AT", "it\u00e4vallansaksa" },
            { "de_CH", "sveitsinyl\u00e4saksa" },
            { "en_AU", "australianenglanti" },
            { "en_CA", "kanadanenglanti" },
            { "en_GB", "britannianenglanti" },
            { "en_US", "amerikanenglanti" },
            { "es_ES", "euroopanespanja" },
            { "es_MX", "meksikonespanja" },
            { "fa_AF", "dari" },
            { "fr_CA", "kanadanranska" },
            { "fr_CH", "sveitsinranska" },
            { "nl_BE", "flaami" },
            { "pt_BR", "brasilianportugali" },
            { "pt_PT", "euroopanportugali" },
            { "ro_MD", "moldova" },
            { "sw_CD", "kongonswahili" },
            { "%%1901", "saksan perinteinen oikeinkirjoitus" },
            { "%%1994", "sloveenin resian murteen yhdenmukaistettu oikeinkirjoitus" },
            { "%%1996", "saksan uusi oikeinkirjoitus" },
            { "ar_001", "yleisarabia" },
            { "es_419", "amerikanespanja" },
            { "key.ca", "kalenteri" },
            { "key.cf", "valuuttojen esitysmuoto" },
            { "key.co", "lajitteluj\u00e4rjestys" },
            { "key.cu", "valuutta" },
            { "key.hc", "tuntij\u00e4rjestelm\u00e4" },
            { "key.lb", "rivinvaihtotyyli" },
            { "key.ms", "mittaj\u00e4rjestelm\u00e4" },
            { "key.nu", "numerot" },
            { "key.tz", "aikavy\u00f6hyke" },
            { "key.va", "maavalinnan muunnelma" },
            { "nds_NL", "alankomaidenalasaksa" },
            { "%%ALUKU", "alukun kreolimurre" },
            { "%%BARLA", "kapverdenkreolin barlaventolainen murreryhm\u00e4" },
            { "%%BISKE", "sloveenin resian San Giorgion/Bilan alamurre" },
            { "%%BOONT", "englannin boontling-murre" },
            { "%%CORNU", "englannin cornu-murre" },
            { "%%JAUER", "retoromaanin jauer-murre" },
            { "%%KKCOR", "kornin yleiskirjoitus" },
            { "%%KSCOR", "kornin Kernowek-ortografia" },
            { "%%LIPAW", "sloveenin resian Lipovazin/Lipovecin alamurre" },
            { "%%NEDIS", "sloveenin natisonen murre" },
            { "%%NJIVA", "sloveenin resian Gnivan/Njivan alamurre" },
            { "%%NULIK", "nykyvolap\u00fck" },
            { "%%OSOJS", "sloveenin resian Oseaccon/Osojanen alamurre" },
            { "%%POSIX", "tietokonem\u00e4\u00e4rittely POSIX" },
            { "%%PUTER", "retoromaanin puter-muoto" },
            { "%%RIGIK", "klassinen volap\u00fck" },
            { "%%ROZAJ", "sloveenin resian murre" },
            { "%%RUMGR", "retoromaanin rumantsch grischun -muoto" },
            { "%%SAAHO", "afarin saho-murre" },
            { "%%SOLBA", "sloveenin resian Stolvizzan/Solbican alamurre" },
            { "%%SOTAV", "kapverdenkreolin sotaventolainen murreryhm\u00e4" },
            { "%%UCCOR", "kornin yhten\u00e4iskirjoitus" },
            { "%%AO1990", "portugalin oikeinkirjoitussopimus 1990" },
            { "%%ARANES", "oksitaanin Aranin laakson variantti" },
            { "%%ASANTE", "akanin asante-variantti" },
            { "%%AUVERN", "oksitaanin Auvergnen variantti" },
            { "%%CISAUP", "oksitaanin luoteisitalialainen variantti" },
            { "%%CREISS", "oksitaanin Croissantin variantti" },
            { "%%DAJNKO", "sloveenin Dajnko-aakkosto" },
            { "%%EKAVSK", "serbian ekavialainen \u00e4\u00e4nt\u00e4mys" },
            { "%%FONIPA", "kansainv\u00e4linen foneettinen aakkosto IPA" },
            { "%%FONUPA", "uralilainen foneettinen aakkosto UPA" },
            { "%%GASCON", "oksitaanin Gasconyn variantti" },
            { "%%GRITAL", "oksitaanin italialaisvaikutteinen ortografia" },
            { "%%NDYUKA", "ndyukan kreolimurre" },
            { "%%NICARD", "oksitaanin Nizzan variantti" },
            { "%%PAMAKA", "pamakan kreolimurre" },
            { "%%PINYIN", "kiinan pinyin-latinaistus" },
            { "%%SCOUSE", "englannin scouse-murre" },
            { "%%SIMPLE", "yksinkertaistettu kielimuoto" },
            { "%%TARASK", "valkoven\u00e4j\u00e4n tara\u0161kevitsa-oikeinkirjoitus" },
            { "%%UCRCOR", "kornin uusittu yhten\u00e4iskirjoitus" },
            { "%%ULSTER", "skotin ulster-murre" },
            { "%%UNIFON", "englannin foneeminen unifon-aakkosto" },
            { "%%ABL1943", "portugalin oikeinkirjoitus 1943" },
            { "%%AKUAPEM", "akanin akuapem-murre" },
            { "%%ALALC97", "amerikkalainen kirjastolatinaistus 1997" },
            { "%%AREVELA", "it\u00e4armenialainen" },
            { "%%AREVMDA", "l\u00e4nsiarmenialainen" },
            { "%%BALANKA", "aniin balankalaismurre" },
            { "%%BAUDDHA", "sanskriitin buddhalainen sekamuoto" },
            { "%%BOHORIC", "sloveenin Bohori\u010d-aakkosto" },
            { "%%EMODENG", "varhaisnykyenglanti" },
            { "%%FONNAPA", "pohjoisamerikkalainen foneettinen aakkosto NAPA" },
            { "%%GRCLASS", "oksitaanin klassinen ortografia" },
            { "%%GRMISTR", "oksitaanin Mistral-vaikutteinen ortografia" },
            { "%%HEPBURN", "japanin Hepburn-latinaistus" },
            { "%%ITIHASA", "sanskriitin eeppinen muoto" },
            { "%%LAUKIKA", "klassinen sanskriitti" },
            { "%%LEMOSIN", "oksitaanin Limousin-alueen variantti" },
            { "%%METELKO", "sloveenin Metelko-aakkosto" },
            { "%%MONOTON", "monotoninen kreikka" },
            { "%%PAHAWH2", "pahawh-hmongin tavukirjoituksen toinen vaihe" },
            { "%%PAHAWH3", "pahawh-hmongin tavukirjoituksen kolmas vaihe" },
            { "%%PAHAWH4", "pahawh-hmongin tavukirjoituksen viimeinen vaihe" },
            { "%%POLYTON", "polytoninen kreikka" },
            { "%%PROVENC", "provensaali" },
            { "%%REVISED", "uudistettu oikeinkirjoitus" },
            { "%%SURSILV", "retoromaanin sursilvan-muoto" },
            { "%%SUTSILV", "retoromaanin sutsilvan-muoto" },
            { "%%VAIDIKA", "sanskriitin veda-murre" },
            { "%%1606NICT", "my\u00f6h\u00e4iskeskiranska" },
            { "%%1694ACAD", "varhaisnykyranska" },
            { "%%1959ACAD", "valkoven\u00e4j\u00e4n virallinen oikeinkirjoitus" },
            { "%%BAKU1926", "yhten\u00e4istetty turkkilainen latinalainen aakkosto" },
            { "%%BASICENG", "Ogdenin perusenglanti" },
            { "%%BISCAYAN", "baskin biskajalaismurre" },
            { "%%BORNHOLM", "Bornholmin murre" },
            { "%%COLB1945", "portugalin oikeinkirjoitus 1945" },
            { "%%FONKIRSH", "Kirshenbaumin foneettinen aakkosto" },
            { "%%FONXSAMP", "foneettinen X-SAMPA-merkist\u00f6" },
            { "%%HOGNORSK", "norjan h\u00f6gnorsk" },
            { "%%HSISTEMO", "esperanton h-kirjoitus" },
            { "%%IJEKAVSK", "serbian ijekavialainen \u00e4\u00e4nt\u00e4mys" },
            { "%%IVANCHOV", "bulgarian 1899 ortografia" },
            { "%%JYUTPING", "kantoninkiinan jyutping-latinaistus" },
            { "%%KOCIEWIE", "puolan kociewielainen murre" },
            { "%%LENGADOC", "oksitaanin lengadocian variantti" },
            { "%%LUNA1918", "ven\u00e4j\u00e4n ortografia 1918" },
            { "%%NEWFOUND", "englannin newfoundlandilaismurre" },
            { "%%OXENDICT", "englannin Oxfordin sanakirjan oikeinkirjoitus" },
            { "%%PETR1708", "ven\u00e4j\u00e4n Pietarin siviiliaakkosto 1708" },
            { "%%SCOTLAND", "skotlanninenglanti" },
            { "%%SPANGLIS", "spanglish" },
            { "%%SURMIRAN", "retoromaanin surmiran-muoto" },
            { "%%VALENCIA", "katalaanin valencian murre" },
            { "%%VALLADER", "reoromaanin vallader-muoto" },
            { "%%VIVARAUP", "oksitaanin vivaro-alpiininen variantti" },
            { "%%WADEGILE", "kiinan Wade-Giles-latinaistus" },
            { "%%XSISTEMO", "esperanton x-kirjoitus" },
            { "type.ca.roc", "Kiinan tasavallan kalenteri" },
            { "type.co.eor", "yleiseurooppalainen lajitteluj\u00e4rjestys" },
            { "type.hc.h11", "12 tunnin j\u00e4rjestelm\u00e4 (0\u201311)" },
            { "type.hc.h12", "12 tunnin j\u00e4rjestelm\u00e4 (1\u201312)" },
            { "type.hc.h23", "24 tunnin j\u00e4rjestelm\u00e4 (0\u201323)" },
            { "type.hc.h24", "24 tunnin j\u00e4rjestelm\u00e4 (1\u201324)" },
            { "type.m0.bgn", "BGN-latinaistus" },
            { "type.nu.ahom", "ahom-numerot" },
            { "type.nu.arab", "arabialaiset numerot" },
            { "type.nu.armn", "armenialaiset numerot" },
            { "type.nu.bali", "balilaiset numerot" },
            { "type.nu.beng", "bengalilaiset numerot" },
            { "type.nu.brah", "brahmilaiset numerot" },
            { "type.nu.cakm", "chakmalaiset numerot" },
            { "type.nu.cham", "cham-numerot" },
            { "type.nu.cyrl", "kyrilliset numerot" },
            { "type.nu.deva", "devanagarinumerot" },
            { "type.nu.diak", "dives akuru -numerot" },
            { "type.nu.ethi", "etiopialaiset numerot" },
            { "type.nu.geor", "georgialaiset numerot" },
            { "type.nu.gong", "gondin gunjala-numerot" },
            { "type.nu.gonm", "gondin masaram-numerot" },
            { "type.nu.grek", "kreikkalaiset numerot" },
            { "type.nu.gujr", "gud\u017earatilaiset numerot" },
            { "type.nu.guru", "gurmukhilaiset numerot" },
            { "type.nu.hans", "yksinkertaistetut kiinalaiset numerot" },
            { "type.nu.hant", "perinteiset kiinalaiset numerot" },
            { "type.nu.hebr", "heprealaiset numerot" },
            { "type.nu.hmng", "pahawh hmong -numerot" },
            { "type.nu.hmnp", "hmongin nyiakeng puachue -numerot" },
            { "type.nu.java", "jaavalaiset numerot" },
            { "type.nu.jpan", "japanilaiset numerot" },
            { "type.nu.kali", "kayah li -numerot" },
            { "type.nu.khmr", "khmeril\u00e4iset numerot" },
            { "type.nu.knda", "kannadalaiset numerot" },
            { "type.nu.lana", "taithamin hora-numerot" },
            { "type.nu.laoo", "laolaiset numerot" },
            { "type.nu.latn", "l\u00e4nsimaiset numerot" },
            { "type.nu.lepc", "lepchanumerot" },
            { "type.nu.limb", "limbunumerot" },
            { "type.nu.mlym", "malajalamilaiset numerot" },
            { "type.nu.modi", "modi-numerot" },
            { "type.nu.mong", "mongolialaiset numerot" },
            { "type.nu.mroo", "mro-numerot" },
            { "type.nu.mtei", "meetei mayek -numerot" },
            { "type.nu.mymr", "burmalaiset numerot" },
            { "type.nu.nkoo", "n\u2019ko-numerot" },
            { "type.nu.olck", "ol chiki -numerot" },
            { "type.nu.orya", "orijalaiset numerot" },
            { "type.nu.osma", "osmanjalaiset numerot" },
            { "type.nu.rohg", "hanifilaisen rohingyan numerot" },
            { "type.nu.saur", "saurashtra-numerot" },
            { "type.nu.shrd", "\u0161arada-numerot" },
            { "type.nu.sind", "khutabadi-numerot" },
            { "type.nu.sinh", "sinhalan lith-numerot" },
            { "type.nu.sora", "sora sompeng -numerot" },
            { "type.nu.sund", "sundalaiset numerot" },
            { "type.nu.takr", "takri-numerot" },
            { "type.nu.talu", "uudet tai lue -numerot" },
            { "type.nu.taml", "perinteiset tamilinumerot" },
            { "type.nu.telu", "telugulaiset numerot" },
            { "type.nu.thai", "thainumerot" },
            { "type.nu.tibt", "tiibetil\u00e4iset numerot" },
            { "type.nu.tirh", "tirhuta-numerot" },
            { "type.nu.vaii", "vai-numerot" },
            { "type.nu.wara", "varang kshiti -numerot" },
            { "type.nu.wcho", "wancholaiset numerot" },
            { "type.ca.dangi", "dangilainen kalenteri" },
            { "type.co.ducet", "Unicoden oletusj\u00e4rjestys" },
            { "type.co.emoji", "emojien lajitteluj\u00e4rjestys" },
            { "type.lb.loose", "v\u00e4lj\u00e4 rivinvaihto" },
            { "type.nu.roman", "roomalaiset numerot" },
            { "type.ca.coptic", "koptilainen kalenteri" },
            { "type.ca.hebrew", "juutalainen kalenteri" },
            { "type.ca.indian", "intialainen kalenteri" },
            { "type.co.compat", "aiempi lajitteluj\u00e4rjestys yhteensopivuutta varten" },
            { "type.co.pinyin", "pinyin-j\u00e4rjestys" },
            { "type.co.search", "yleishakuj\u00e4rjestys" },
            { "type.co.stroke", "piirtoj\u00e4rjestys" },
            { "type.co.unihan", "radikaali- ja piirtoj\u00e4rjestys" },
            { "type.co.zhuyin", "zhuyin-j\u00e4rjestys" },
            { "type.d0.fwidth", "ideogrammin levyinen" },
            { "type.d0.hwidth", "ideogrammin puolikkaan levyinen" },
            { "type.lb.normal", "normaali rivinvaihto" },
            { "type.lb.strict", "tarkka rivinvaihto" },
            { "type.m0.ungegn", "UNGEGN-latinaistus" },
            { "type.ms.metric", "metrij\u00e4rjestelm\u00e4" },
            { "type.nu.native", "kielen omat numerot" },
            { "type.ca.chinese", "kiinalainen kalenteri" },
            { "type.ca.islamic", "islamilainen kalenteri" },
            { "type.ca.iso8601", "ISO 8601 -kalenteri" },
            { "type.ca.persian", "persialainen kalenteri" },
            { "type.cf.account", "valuuttojen laskentatoimen esitysmuoto" },
            { "type.co.big5han", "perinteinen kiinalainen j\u00e4rjestys Big5" },
            { "type.d0.npinyin", "numeerinen muunnos" },
            { "type.nu.arabext", "laajennetut arabialaiset numerot" },
            { "type.nu.armnlow", "armenialaiset piennumerot" },
            { "type.nu.finance", "talousnumerot" },
            { "type.nu.greklow", "kreikkalaiset piennumerot" },
            { "type.nu.hanidec", "kiinalaiset desimaalinumerot" },
            { "type.nu.hansfin", "yksinkertaistetut kiinalaiset talousnumerot" },
            { "type.nu.hantfin", "perinteiset kiinalaiset talousnumerot" },
            { "type.nu.jpanfin", "japanilaiset talousnumerot" },
            { "type.nu.mathdbl", "matemaattiset kaksoisly\u00f6ntinumerot" },
            { "type.nu.tamldec", "tamilinumerot" },
            { "type.ca.buddhist", "buddhalainen kalenteri" },
            { "type.ca.ethiopic", "etiopialainen kalenteri" },
            { "type.ca.japanese", "japanilainen kalenteri" },
            { "type.cf.standard", "valuuttojen vakioesitysmuoto" },
            { "type.co.phonetic", "\u00e4\u00e4nteellinen j\u00e4rjestys" },
            { "type.co.reformed", "uudistettu j\u00e4rjestys" },
            { "type.co.searchjl", "haku hangul-alkukonsonantin mukaan" },
            { "type.co.standard", "normaalij\u00e4rjestys" },
            { "type.ms.uksystem", "brittil\u00e4inen mittaj\u00e4rjestelm\u00e4" },
            { "type.ms.ussystem", "yhdysvaltalainen mittaj\u00e4rjestelm\u00e4" },
            { "type.nu.fullwide", "ideografin levyiset numerot" },
            { "type.nu.lanatham", "taithamin tham-numerot" },
            { "type.nu.mathbold", "matemaattiset lihavoidut numerot" },
            { "type.nu.mathmono", "matemaattiset tasalevyiset numerot" },
            { "type.nu.mathsanb", "matemaattiset p\u00e4\u00e4teviivattomat lihavoidut numerot" },
            { "type.nu.mathsans", "matemaattiset p\u00e4\u00e4teviivattomat numerot" },
            { "type.nu.mymrshan", "myanmarin shan-numerot" },
            { "type.nu.mymrtlng", "myanmarin tai laing -numerot" },
            { "type.nu.romanlow", "roomalaiset piennumerot" },
            { "type.ca.gregorian", "gregoriaaninen kalenteri" },
            { "type.co.gb2312han", "yksinkertaistettu kiinalainen j\u00e4rjestys GB2312" },
            { "type.co.phonebook", "puhelinluetteloj\u00e4rjestys" },
            { "type.co.dictionary", "sanakirjaj\u00e4rjestys" },
            { "type.co.traditional", "perinteinen j\u00e4rjestys" },
            { "type.nu.traditional", "perinteiset numerot" },
            { "type.ca.islamic-rgsa", "islamilainen saudiarabialainen kalenteri" },
            { "type.ca.islamic-tbla", "islamilainen matemaattinen kalenteri, torstai-epookki" },
            { "type.ca.islamic-civil", "islamilainen siviilikalenteri, perjantai-epookki" },
            { "type.ca.islamic-umalqura", "islamilainen Umm al-Qura -kalenteri" },
            { "type.ca.ethiopic-amete-alem", "etiopialainen amete alem -kalenteri" },
        };
        return data;
    }
}
