// SPDX-License-Identifier: GPL-2.0-or-later
/*
 * Copyright (c) 2022 Rockchip Electronics Co., Ltd.
 * Based on Sebastian Reichel's implementation for RK3588
 */

#include <dm.h>
#include <asm/arch-rockchip/clock.h>
#include <dt-bindings/reset/rockchip,rk3528-cru.h>

/* 0xFF4A0000 + 0x0A00 */
#define RK3528_CRU_RESET_OFFSET(id, reg, bit) [id] = (0 + reg * 16 + bit)

/* mapping table for reset ID to register offset */
static const int rk3528_register_offset[] = {
	/* CRU_SOFTRST_CON03 */
	RK3528_CRU_RESET_OFFSET(SRST_CORE0_PO, 3, 0),
	RK3528_CRU_RESET_OFFSET(SRST_CORE1_PO, 3, 1),
	RK3528_CRU_RESET_OFFSET(SRST_CORE2_PO, 3, 2),
	RK3528_CRU_RESET_OFFSET(SRST_CORE3_PO, 3, 3),
	RK3528_CRU_RESET_OFFSET(SRST_CORE0, 3, 4),
	RK3528_CRU_RESET_OFFSET(SRST_CORE1, 3, 5),
	RK3528_CRU_RESET_OFFSET(SRST_CORE2, 3, 6),
	RK3528_CRU_RESET_OFFSET(SRST_CORE3, 3, 7),
	RK3528_CRU_RESET_OFFSET(SRST_NL2, 3, 8),
	RK3528_CRU_RESET_OFFSET(SRST_CORE_BIU, 3, 9),
	RK3528_CRU_RESET_OFFSET(SRST_CORE_CRYPTO, 3, 10),

	/* CRU_SOFTRST_CON05 */
	RK3528_CRU_RESET_OFFSET(SRST_P_DBG, 5, 13),
	RK3528_CRU_RESET_OFFSET(SRST_POT_DBG, 5, 14),
	RK3528_CRU_RESET_OFFSET(SRST_NT_DBG, 5, 15),

	/* CRU_SOFTRST_CON06 */
	RK3528_CRU_RESET_OFFSET(SRST_P_CORE_GRF, 6, 2),
	RK3528_CRU_RESET_OFFSET(SRST_P_DAPLITE_BIU, 6, 3),
	RK3528_CRU_RESET_OFFSET(SRST_P_CPU_BIU, 6, 4),
	RK3528_CRU_RESET_OFFSET(SRST_REF_PVTPLL_CORE, 6, 7),

	/* CRU_SOFTRST_CON08 */
	RK3528_CRU_RESET_OFFSET(SRST_A_BUS_VOPGL_BIU, 8, 1),
	RK3528_CRU_RESET_OFFSET(SRST_A_BUS_H_BIU, 8, 3),
	RK3528_CRU_RESET_OFFSET(SRST_A_SYSMEM_BIU, 8, 8),
	RK3528_CRU_RESET_OFFSET(SRST_A_BUS_BIU, 8, 10),
	RK3528_CRU_RESET_OFFSET(SRST_H_BUS_BIU, 8, 11),
	RK3528_CRU_RESET_OFFSET(SRST_P_BUS_BIU, 8, 12),
	RK3528_CRU_RESET_OFFSET(SRST_P_DFT2APB, 8, 13),
	RK3528_CRU_RESET_OFFSET(SRST_P_BUS_GRF, 8, 15),

	/* CRU_SOFTRST_CON09 */
	RK3528_CRU_RESET_OFFSET(SRST_A_BUS_M_BIU, 9, 0),
	RK3528_CRU_RESET_OFFSET(SRST_A_GIC, 9, 1),
	RK3528_CRU_RESET_OFFSET(SRST_A_SPINLOCK, 9, 2),
	RK3528_CRU_RESET_OFFSET(SRST_A_DMAC, 9, 4),
	RK3528_CRU_RESET_OFFSET(SRST_P_TIMER, 9, 5),
	RK3528_CRU_RESET_OFFSET(SRST_TIMER0, 9, 6),
	RK3528_CRU_RESET_OFFSET(SRST_TIMER1, 9, 7),
	RK3528_CRU_RESET_OFFSET(SRST_TIMER2, 9, 8),
	RK3528_CRU_RESET_OFFSET(SRST_TIMER3, 9, 9),
	RK3528_CRU_RESET_OFFSET(SRST_TIMER4, 9, 10),
	RK3528_CRU_RESET_OFFSET(SRST_TIMER5, 9, 11),
	RK3528_CRU_RESET_OFFSET(SRST_P_JDBCK_DAP, 9, 12),
	RK3528_CRU_RESET_OFFSET(SRST_JDBCK_DAP, 9, 13),
	RK3528_CRU_RESET_OFFSET(SRST_P_WDT_NS, 9, 15),

	/* CRU_SOFTRST_CON10 */
	RK3528_CRU_RESET_OFFSET(SRST_T_WDT_NS, 10, 0),
	RK3528_CRU_RESET_OFFSET(SRST_H_TRNG_NS, 10, 3),
	RK3528_CRU_RESET_OFFSET(SRST_P_UART0, 10, 7),
	RK3528_CRU_RESET_OFFSET(SRST_S_UART0, 10, 8),
	RK3528_CRU_RESET_OFFSET(SRST_PKA_CRYPTO, 10, 10),
	RK3528_CRU_RESET_OFFSET(SRST_A_CRYPTO, 10, 11),
	RK3528_CRU_RESET_OFFSET(SRST_H_CRYPTO, 10, 12),
	RK3528_CRU_RESET_OFFSET(SRST_P_DMA2DDR, 10, 13),
	RK3528_CRU_RESET_OFFSET(SRST_A_DMA2DDR, 10, 14),

	/* CRU_SOFTRST_CON11 */
	RK3528_CRU_RESET_OFFSET(SRST_P_PWM0, 11, 4),
	RK3528_CRU_RESET_OFFSET(SRST_PWM0, 11, 5),
	RK3528_CRU_RESET_OFFSET(SRST_P_PWM1, 11, 7),
	RK3528_CRU_RESET_OFFSET(SRST_PWM1, 11, 8),
	RK3528_CRU_RESET_OFFSET(SRST_P_SCR, 11, 10),
	RK3528_CRU_RESET_OFFSET(SRST_A_DCF, 11, 11),
	RK3528_CRU_RESET_OFFSET(SRST_P_INTMUX, 11, 12),

	/* CRU_SOFTRST_CON25 */
	RK3528_CRU_RESET_OFFSET(SRST_A_VPU_BIU, 25, 6),
	RK3528_CRU_RESET_OFFSET(SRST_H_VPU_BIU, 25, 7),
	RK3528_CRU_RESET_OFFSET(SRST_P_VPU_BIU, 25, 8),
	RK3528_CRU_RESET_OFFSET(SRST_A_VPU, 25, 9),
	RK3528_CRU_RESET_OFFSET(SRST_H_VPU, 25, 10),
	RK3528_CRU_RESET_OFFSET(SRST_P_CRU_PCIE, 25, 11),
	RK3528_CRU_RESET_OFFSET(SRST_P_VPU_GRF, 25, 12),
	RK3528_CRU_RESET_OFFSET(SRST_H_SFC, 25, 13),
	RK3528_CRU_RESET_OFFSET(SRST_S_SFC, 25, 14),
	RK3528_CRU_RESET_OFFSET(SRST_C_EMMC, 25, 15),

	/* CRU_SOFTRST_CON26 */
	RK3528_CRU_RESET_OFFSET(SRST_H_EMMC, 26, 0),
	RK3528_CRU_RESET_OFFSET(SRST_A_EMMC, 26, 1),
	RK3528_CRU_RESET_OFFSET(SRST_B_EMMC, 26, 2),
	RK3528_CRU_RESET_OFFSET(SRST_T_EMMC, 26, 3),
	RK3528_CRU_RESET_OFFSET(SRST_P_GPIO1, 26, 4),
	RK3528_CRU_RESET_OFFSET(SRST_DB_GPIO1, 26, 5),
	RK3528_CRU_RESET_OFFSET(SRST_A_VPU_L_BIU, 26, 6),
	RK3528_CRU_RESET_OFFSET(SRST_P_VPU_IOC, 26, 8),
	RK3528_CRU_RESET_OFFSET(SRST_H_SAI_I2S0, 26, 9),
	RK3528_CRU_RESET_OFFSET(SRST_M_SAI_I2S0, 26, 10),
	RK3528_CRU_RESET_OFFSET(SRST_H_SAI_I2S2, 26, 11),
	RK3528_CRU_RESET_OFFSET(SRST_M_SAI_I2S2, 26, 12),
	RK3528_CRU_RESET_OFFSET(SRST_P_ACODEC, 26, 13),

	/* CRU_SOFTRST_CON27 */
	RK3528_CRU_RESET_OFFSET(SRST_P_GPIO3, 27, 0),
	RK3528_CRU_RESET_OFFSET(SRST_DB_GPIO3, 27, 1),
	RK3528_CRU_RESET_OFFSET(SRST_P_SPI1, 27, 4),
	RK3528_CRU_RESET_OFFSET(SRST_SPI1, 27, 5),
	RK3528_CRU_RESET_OFFSET(SRST_P_UART2, 27, 7),
	RK3528_CRU_RESET_OFFSET(SRST_S_UART2, 27, 8),
	RK3528_CRU_RESET_OFFSET(SRST_P_UART5, 27, 9),
	RK3528_CRU_RESET_OFFSET(SRST_S_UART5, 27, 10),
	RK3528_CRU_RESET_OFFSET(SRST_P_UART6, 27, 11),
	RK3528_CRU_RESET_OFFSET(SRST_S_UART6, 27, 12),
	RK3528_CRU_RESET_OFFSET(SRST_P_UART7, 27, 13),
	RK3528_CRU_RESET_OFFSET(SRST_S_UART7, 27, 14),
	RK3528_CRU_RESET_OFFSET(SRST_P_I2C3, 27, 15),

	/* CRU_SOFTRST_CON28 */
	RK3528_CRU_RESET_OFFSET(SRST_I2C3, 28, 0),
	RK3528_CRU_RESET_OFFSET(SRST_P_I2C5, 28, 1),
	RK3528_CRU_RESET_OFFSET(SRST_I2C5, 28, 2),
	RK3528_CRU_RESET_OFFSET(SRST_P_I2C6, 28, 3),
	RK3528_CRU_RESET_OFFSET(SRST_I2C6, 28, 4),
	RK3528_CRU_RESET_OFFSET(SRST_A_MAC, 28, 5),

	/* CRU_SOFTRST_CON30 */
	RK3528_CRU_RESET_OFFSET(SRST_P_PCIE, 30, 1),
	RK3528_CRU_RESET_OFFSET(SRST_PCIE_PIPE_PHY, 30, 2),
	RK3528_CRU_RESET_OFFSET(SRST_PCIE_POWER_UP, 30, 3),
	RK3528_CRU_RESET_OFFSET(SRST_P_PCIE_PHY, 30, 6),
	RK3528_CRU_RESET_OFFSET(SRST_P_PIPE_GRF, 30, 7),

	/* CRU_SOFTRST_CON32 */
	RK3528_CRU_RESET_OFFSET(SRST_H_SDIO0, 32, 2),
	RK3528_CRU_RESET_OFFSET(SRST_H_SDIO1, 32, 4),
	RK3528_CRU_RESET_OFFSET(SRST_TS_0, 32, 5),
	RK3528_CRU_RESET_OFFSET(SRST_TS_1, 32, 6),
	RK3528_CRU_RESET_OFFSET(SRST_P_CAN2, 32, 7),
	RK3528_CRU_RESET_OFFSET(SRST_CAN2, 32, 8),
	RK3528_CRU_RESET_OFFSET(SRST_P_CAN3, 32, 9),
	RK3528_CRU_RESET_OFFSET(SRST_CAN3, 32, 10),
	RK3528_CRU_RESET_OFFSET(SRST_P_SARADC, 32, 11),
	RK3528_CRU_RESET_OFFSET(SRST_SARADC, 32, 12),
	RK3528_CRU_RESET_OFFSET(SRST_SARADC_PHY, 32, 13),
	RK3528_CRU_RESET_OFFSET(SRST_P_TSADC, 32, 14),
	RK3528_CRU_RESET_OFFSET(SRST_TSADC, 32, 15),

	/* CRU_SOFTRST_CON33 */
	RK3528_CRU_RESET_OFFSET(SRST_A_USB3OTG, 33, 1),

	/* CRU_SOFTRST_CON34 */
	RK3528_CRU_RESET_OFFSET(SRST_A_GPU_BIU, 34, 3),
	RK3528_CRU_RESET_OFFSET(SRST_P_GPU_BIU, 34, 5),
	RK3528_CRU_RESET_OFFSET(SRST_A_GPU, 34, 8),
	RK3528_CRU_RESET_OFFSET(SRST_REF_PVTPLL_GPU, 34, 9),

	/* CRU_SOFTRST_CON36 */
	RK3528_CRU_RESET_OFFSET(SRST_H_RKVENC_BIU, 36, 3),
	RK3528_CRU_RESET_OFFSET(SRST_A_RKVENC_BIU, 36, 4),
	RK3528_CRU_RESET_OFFSET(SRST_P_RKVENC_BIU, 36, 5),
	RK3528_CRU_RESET_OFFSET(SRST_H_RKVENC, 36, 6),
	RK3528_CRU_RESET_OFFSET(SRST_A_RKVENC, 36, 7),
	RK3528_CRU_RESET_OFFSET(SRST_CORE_RKVENC, 36, 8),
	RK3528_CRU_RESET_OFFSET(SRST_H_SAI_I2S1, 36, 9),
	RK3528_CRU_RESET_OFFSET(SRST_M_SAI_I2S1, 36, 10),
	RK3528_CRU_RESET_OFFSET(SRST_P_I2C1, 36, 11),
	RK3528_CRU_RESET_OFFSET(SRST_I2C1, 36, 12),
	RK3528_CRU_RESET_OFFSET(SRST_P_I2C0, 36, 13),
	RK3528_CRU_RESET_OFFSET(SRST_I2C0, 36, 14),

	/* CRU_SOFTRST_CON37 */
	RK3528_CRU_RESET_OFFSET(SRST_P_SPI0, 37, 2),
	RK3528_CRU_RESET_OFFSET(SRST_SPI0, 37, 3),
	RK3528_CRU_RESET_OFFSET(SRST_P_GPIO4, 37, 8),
	RK3528_CRU_RESET_OFFSET(SRST_DB_GPIO4, 37, 9),
	RK3528_CRU_RESET_OFFSET(SRST_P_RKVENC_IOC, 37, 10),
	RK3528_CRU_RESET_OFFSET(SRST_H_SPDIF, 37, 14),
	RK3528_CRU_RESET_OFFSET(SRST_M_SPDIF, 37, 15),

	/* CRU_SOFTRST_CON38 */
	RK3528_CRU_RESET_OFFSET(SRST_H_PDM, 38, 0),
	RK3528_CRU_RESET_OFFSET(SRST_M_PDM, 38, 1),
	RK3528_CRU_RESET_OFFSET(SRST_P_UART1, 38, 2),
	RK3528_CRU_RESET_OFFSET(SRST_S_UART1, 38, 3),
	RK3528_CRU_RESET_OFFSET(SRST_P_UART3, 38, 4),
	RK3528_CRU_RESET_OFFSET(SRST_S_UART3, 38, 5),
	RK3528_CRU_RESET_OFFSET(SRST_P_RKVENC_GRF, 38, 6),
	RK3528_CRU_RESET_OFFSET(SRST_P_CAN0, 38, 7),
	RK3528_CRU_RESET_OFFSET(SRST_CAN0, 38, 8),
	RK3528_CRU_RESET_OFFSET(SRST_P_CAN1, 38, 9),
	RK3528_CRU_RESET_OFFSET(SRST_CAN1, 38, 10),

	/* CRU_SOFTRST_CON39 */
	RK3528_CRU_RESET_OFFSET(SRST_A_VO_BIU, 39, 3),
	RK3528_CRU_RESET_OFFSET(SRST_H_VO_BIU, 39, 4),
	RK3528_CRU_RESET_OFFSET(SRST_P_VO_BIU, 39, 5),
	RK3528_CRU_RESET_OFFSET(SRST_H_RGA2E, 39, 7),
	RK3528_CRU_RESET_OFFSET(SRST_A_RGA2E, 39, 8),
	RK3528_CRU_RESET_OFFSET(SRST_CORE_RGA2E, 39, 9),
	RK3528_CRU_RESET_OFFSET(SRST_H_VDPP, 39, 10),
	RK3528_CRU_RESET_OFFSET(SRST_A_VDPP, 39, 11),
	RK3528_CRU_RESET_OFFSET(SRST_CORE_VDPP, 39, 12),
	RK3528_CRU_RESET_OFFSET(SRST_P_VO_GRF, 39, 13),
	RK3528_CRU_RESET_OFFSET(SRST_P_CRU, 39, 15),

	/* CRU_SOFTRST_CON40 */
	RK3528_CRU_RESET_OFFSET(SRST_A_VOP_BIU, 40, 1),
	RK3528_CRU_RESET_OFFSET(SRST_H_VOP, 40, 2),
	RK3528_CRU_RESET_OFFSET(SRST_D_VOP0, 40, 3),
	RK3528_CRU_RESET_OFFSET(SRST_D_VOP1, 40, 4),
	RK3528_CRU_RESET_OFFSET(SRST_A_VOP, 40, 5),
	RK3528_CRU_RESET_OFFSET(SRST_P_HDMI, 40, 6),
	RK3528_CRU_RESET_OFFSET(SRST_HDMI, 40, 7),
	RK3528_CRU_RESET_OFFSET(SRST_P_HDMIPHY, 40, 14),
	RK3528_CRU_RESET_OFFSET(SRST_H_HDCP_KEY, 40, 15),

	/* CRU_SOFTRST_CON41 */
	RK3528_CRU_RESET_OFFSET(SRST_A_HDCP, 41, 0),
	RK3528_CRU_RESET_OFFSET(SRST_H_HDCP, 41, 1),
	RK3528_CRU_RESET_OFFSET(SRST_P_HDCP, 41, 2),
	RK3528_CRU_RESET_OFFSET(SRST_H_CVBS, 41, 3),
	RK3528_CRU_RESET_OFFSET(SRST_D_CVBS_VOP, 41, 4),
	RK3528_CRU_RESET_OFFSET(SRST_D_4X_CVBS_VOP, 41, 5),
	RK3528_CRU_RESET_OFFSET(SRST_A_JPEG_DECODER, 41, 6),
	RK3528_CRU_RESET_OFFSET(SRST_H_JPEG_DECODER, 41, 7),
	RK3528_CRU_RESET_OFFSET(SRST_A_VO_L_BIU, 41, 9),
	RK3528_CRU_RESET_OFFSET(SRST_A_MAC_VO, 41, 10),

	/* CRU_SOFTRST_CON42 */
	RK3528_CRU_RESET_OFFSET(SRST_A_JPEG_BIU, 42, 0),
	RK3528_CRU_RESET_OFFSET(SRST_H_SAI_I2S3, 42, 1),
	RK3528_CRU_RESET_OFFSET(SRST_M_SAI_I2S3, 42, 2),
	RK3528_CRU_RESET_OFFSET(SRST_MACPHY, 42, 3),
	RK3528_CRU_RESET_OFFSET(SRST_P_VCDCPHY, 42, 4),
	RK3528_CRU_RESET_OFFSET(SRST_P_GPIO2, 42, 5),
	RK3528_CRU_RESET_OFFSET(SRST_DB_GPIO2, 42, 6),
	RK3528_CRU_RESET_OFFSET(SRST_P_VO_IOC, 42, 7),
	RK3528_CRU_RESET_OFFSET(SRST_H_SDMMC0, 42, 9),
	RK3528_CRU_RESET_OFFSET(SRST_P_OTPC_NS, 42, 11),
	RK3528_CRU_RESET_OFFSET(SRST_SBPI_OTPC_NS, 42, 12),
	RK3528_CRU_RESET_OFFSET(SRST_USER_OTPC_NS, 42, 13),

	/* CRU_SOFTRST_CON43 */
	RK3528_CRU_RESET_OFFSET(SRST_HDMIHDP0, 43, 2),
	RK3528_CRU_RESET_OFFSET(SRST_H_USBHOST, 43, 3),
	RK3528_CRU_RESET_OFFSET(SRST_H_USBHOST_ARB, 43, 4),
	RK3528_CRU_RESET_OFFSET(SRST_HOST_UTMI, 43, 6),
	RK3528_CRU_RESET_OFFSET(SRST_P_UART4, 43, 7),
	RK3528_CRU_RESET_OFFSET(SRST_S_UART4, 43, 8),
	RK3528_CRU_RESET_OFFSET(SRST_P_I2C4, 43, 9),
	RK3528_CRU_RESET_OFFSET(SRST_I2C4, 43, 10),
	RK3528_CRU_RESET_OFFSET(SRST_P_I2C7, 43, 11),
	RK3528_CRU_RESET_OFFSET(SRST_I2C7, 43, 12),
	RK3528_CRU_RESET_OFFSET(SRST_P_USBPHY, 43, 13),
	RK3528_CRU_RESET_OFFSET(SRST_USBPHY_POR, 43, 14),
	RK3528_CRU_RESET_OFFSET(SRST_USBPHY_OTG, 43, 15),

	/* CRU_SOFTRST_CON44 */
	RK3528_CRU_RESET_OFFSET(SRST_USBPHY_HOST, 44, 0),
	RK3528_CRU_RESET_OFFSET(SRST_P_DDRPHY_CRU, 44, 4),
	RK3528_CRU_RESET_OFFSET(SRST_H_RKVDEC_BIU, 44, 6),
	RK3528_CRU_RESET_OFFSET(SRST_A_RKVDEC_BIU, 44, 7),
	RK3528_CRU_RESET_OFFSET(SRST_A_RKVDEC, 44, 8),
	RK3528_CRU_RESET_OFFSET(SRST_H_RKVDEC, 44, 9),
	RK3528_CRU_RESET_OFFSET(SRST_HEVC_CA_RKVDEC, 44, 11),
	RK3528_CRU_RESET_OFFSET(SRST_REF_PVTPLL_RKVDEC, 44, 12),

	/* CRU_SOFTRST_CON45 */
	RK3528_CRU_RESET_OFFSET(SRST_P_DDR_BIU, 45, 1),
	RK3528_CRU_RESET_OFFSET(SRST_P_DDRC, 45, 2),
	RK3528_CRU_RESET_OFFSET(SRST_P_DDRMON, 45, 3),
	RK3528_CRU_RESET_OFFSET(SRST_TIMER_DDRMON, 45, 4),
	RK3528_CRU_RESET_OFFSET(SRST_P_MSCH_BIU, 45, 5),
	RK3528_CRU_RESET_OFFSET(SRST_P_DDR_GRF, 45, 6),
	RK3528_CRU_RESET_OFFSET(SRST_P_DDR_HWLP, 45, 8),
	RK3528_CRU_RESET_OFFSET(SRST_P_DDRPHY, 45, 9),
	RK3528_CRU_RESET_OFFSET(SRST_MSCH_BIU, 45, 10),
	RK3528_CRU_RESET_OFFSET(SRST_A_DDR_UPCTL, 45, 11),
	RK3528_CRU_RESET_OFFSET(SRST_DDR_UPCTL, 45, 12),
	RK3528_CRU_RESET_OFFSET(SRST_DDRMON, 45, 13),
	RK3528_CRU_RESET_OFFSET(SRST_A_DDR_SCRAMBLE, 45, 14),
	RK3528_CRU_RESET_OFFSET(SRST_A_SPLIT, 45, 15),

	/* CRU_SOFTRST_CON46 */
	RK3528_CRU_RESET_OFFSET(SRST_DDR_PHY, 46, 0),
};

int rk3528_reset_bind_lut(struct udevice *pdev, u32 reg_offset, u32 reg_number)
{
	return rockchip_reset_bind_lut(pdev, rk3528_register_offset,
				       reg_offset, reg_number);
}
